import React, { Component } from "react";
import "./HighLowGame.css";

class HighLowGame extends Component {
  constructor(props) {
    super(props);
    this.state = {
      randomNumber: this.generateRandomNumber(),
      guess: "",
      message: "",
      numberOfGuesses: 0,
      timer: 60,
    };
    this.handleChange = this.handleChange.bind(this);
    this.handleSubmit = this.handleSubmit.bind(this);
  }

  componentDidMount() {
    console.log("Component mounted");
    
    this.timerInterval = setInterval(() => {
      this.setState((prevState) => ({
        timer: prevState.timer - 1,
      }), () => {
        if (this.state.timer === 0) {
          this.endGame("Time's up! You ran out of time.");
        }
      });
    }, 1000);
  }

  componentWillUnmount() {
    console.log("Component will unmount");
    
    clearInterval(this.timerInterval);
  }

  shouldComponentUpdate(nextProps, nextState) {
    
    return nextState.message !== this.state.message || nextState.timer !== this.state.timer;
  }

  componentDidUpdate(prevProps, prevState) {
    console.log("Component updated");
    if (prevState.timer !== 0 && this.state.timer === 0) {
      this.endGame("Time's up! You ran out of time.");
    }
  }

  generateRandomNumber() {
    
    return Math.floor(Math.random() * 1000);
  }

  handleChange(event) {
    this.setState({ guess: event.target.value });
  }

  handleSubmit(event) {
    event.preventDefault();
    const guess = parseInt(this.state.guess);
    const { randomNumber, numberOfGuesses } = this.state;

    if (isNaN(guess)) {
      this.setState({ message: "Please enter a valid number." });
      return;
    }

    if (guess === randomNumber) {
      this.setState({ message: `Congratulations! You guessed it right in ${numberOfGuesses + 1} guesses.` });
    } else if (guess < randomNumber) {
      this.setState((prevState) => ({
        message: "Too low! Try again.",
        guess: "",
        numberOfGuesses: prevState.numberOfGuesses + 1,
      }));
    } else {
      this.setState((prevState) => ({
        message: "Too high! Try again.",
        guess: "",
        numberOfGuesses: prevState.numberOfGuesses + 1,
      }));
    }
  }

  endGame(message) {
    
    clearInterval(this.timerInterval);
    this.setState({ message }, () => {
      
      setTimeout(() => {
        this.setState({
          randomNumber: this.generateRandomNumber(),
          guess: "",
          message: "",
          numberOfGuesses: 0,
          timer: 60,
        });
        
        this.timerInterval = setInterval(() => {
          this.setState((prevState) => ({
            timer: prevState.timer - 1,
          }), () => {
            if (this.state.timer === 0) {
              this.endGame("Time's up! You ran out of time.");
            }
          });
        }, 1000);
      }, 2000);
    });
  }

  render() {
    const { message, guess, numberOfGuesses, timer } = this.state;

    return (
      <div className="HighLowGame">
        <p>{message}</p>
        <p>Number of guesses: {numberOfGuesses}</p>
        <p>Time remaining: {timer} seconds</p>
        <form onSubmit={this.handleSubmit}>
          <input
            type="number"
            value={guess}
            onChange={this.handleChange}
            placeholder="Enter your guess"
            min="0"
            max="999"
            required
          />
          <button type="submit">Guess</button>
        </form>
      </div>
    );
  }
}

export default HighLowGame;
